<?php

function getNameFromCode($json, $code)
{
	foreach ($json as $country) {
		if ($country['code'] == $code) {
			return $country['name'];
		}
	}

	return false;
}

session_start();
include 'assets/includes/db.php';
include 'assets/includes/config.php';

if ($_ERRORS) {
	error_reporting(E_ALL);
	ini_set('display_errors', 1);
}
if (!isset($_SESSION['loggedin']) && !$_SESSION['loggedin']) {
	header('location: logout.php');
}

if (isset($_POST['add_config'])) {
	$sql = 'INSERT INTO ovpn_config (';
	$sql .= 'vpn_country, ';
	$sql .= 'vpn_location, ';
	$sql .= 'vpn_config, ';
	$sql .= 'vpn_status, ';
	$sql .= 'vpn_type, ';
	$sql .= 'auth_type, ';
	$sql .= 'auth_embedded) ';
	$sql .= 'VALUES (';
	$sql .= '\'' . $_POST['add-country'] . '\', ';
	$sql .= '\'' . $_POST['add-location'] . '\', ';
	$sql .= '\'' . $_POST['add-url'] . '\', ';
	$sql .= '\'' . $_POST['add-status'] . '\', ';
	$sql .= '\'' . $_POST['add-type'] . '\', ';
	$sql .= '\'' . $_POST['add-auth-type'] . '\', ';
	$sql .= '\'' . $_POST['add-auth-embedded'] . '\');';
	$sqlite3->exec($sql);
	header('Location: ottrunvpn_ovpn.php');
}

if (isset($_POST['edit_config'])) {
	$sql = 'UPDATE ovpn_config SET ';
	$sql .= 'vpn_country = \'' . $_POST['edit-country'] . '\', ';
	$sql .= 'vpn_location = \'' . $_POST['edit-location'] . '\', ';
	$sql .= 'vpn_state = \'' . $_POST['edit-state'] . '\', ';
	$sql .= 'vpn_config = \'' . $_POST['edit-url'] . '\',';
	$sql .= 'vpn_status = \'' . $_POST['edit-status'] . '\',';
	$sql .= 'vpn_type = \'' . $_POST['edit-type'] . '\',';
	$sql .= 'auth_type = \'' . $_POST['edit-auth-type'] . '\',';
	$sql .= 'auth_embedded = \'' . $_POST['edit-auth-embedded'] . '\' ';
	$sql .= 'WHERE id = ' . $_POST['edit-id'] . ';';
	$sqlite3->exec($sql);
	header('Location: ottrunvpn_ovpn.php');
}

if (isset($_GET['disable_config'])) {
	$sql = 'UPDATE ovpn_config SET ';
	$sql .= 'vpn_status = \'INACTIVE\' ';
	$sql .= 'WHERE id = ' . $_GET['disable_config'] . ';';
	$sqlite3->exec($sql);
	header('Location: ottrunvpn_ovpn.php');
}

if (isset($_GET['enable_config'])) {
	$sql = 'UPDATE ovpn_config SET ';
	$sql .= 'vpn_status = \'ACTIVE\' ';
	$sql .= 'WHERE id = ' . $_GET['enable_config'] . ';';
	$sqlite3->exec($sql);
	header('Location: ottrunvpn_ovpn.php');
}

if (isset($_POST['delete_config'])) {
	$sql = 'DELETE FROM ovpn_config ';
	$sql .= 'WHERE id = ' . $_POST['delete-id'] . ';';
	$sqlite3->exec($sql);
	header('Location: ottrunvpn_ovpn.php');
}

if (isset($_POST['save_ovpn_credentials'])) {
	$sql = 'UPDATE ovpn_credentials SET ';
	$sql .= 'ovpn_username = \'' . $_POST['openvpn-user-name'] . '\', ';
	$sql .= 'ovpn_password = \'' . $_POST['openvpn-password'] . '\';';
	$sqlite3->exec($sql);
	header('Location: ottrunvpn_ovpn.php');
}

if (isset($_POST['save_surfshark_credentials'])) {
	$sql = 'UPDATE ovpn_credentials SET ';
	$sql .= 'surfshark_username = \'' . $_POST['surfshark-username'] . '\', ';
	$sql .= 'surfshark_password = \'' . $_POST['surfshark-password'] . '\';';
	$sqlite3->exec($sql);
	header('Location: ottrunvpn_ovpn.php');
}

if (isset($_POST['save_ipvanish_credentials'])) {
	$sql = 'UPDATE ovpn_credentials SET ';
	$sql .= 'ipvanish_username = \'' . $_POST['ipvanish-username'] . '\', ';
	$sql .= 'ipvanish_password = \'' . $_POST['ipvanish-password'] . '\';';
	$sqlite3->exec($sql);
	header('Location: ottrunvpn_ovpn.php');
}

if (isset($_POST['save_nordvpn_credentials'])) {
	$sql = 'UPDATE ovpn_credentials SET ';
	$sql .= 'nordvpn_username = \'' . $_POST['nordvpn-username'] . '\', ';
	$sql .= 'nordvpn_password = \'' . $_POST['nordvpn-password'] . '\';';
	$sqlite3->exec($sql);
	header('Location: ottrunvpn_ovpn.php');
}

if (isset($_POST['update-sorting'])) {
	$sql = 'UPDATE ovpn_sorting SET ';
	$sql .= 'group_by = \'' . $_POST['group-by'] . '\', ';
	$sql .= 'order_by = \'' . $_POST['order'] . '\';';
	$sqlite3->exec($sql);
	header('Location: ottrunvpn_ovpn.php');
}

$json_data = json_decode(file_get_contents('./assets/data/country_name.json'), true);
echo '<!doctype html>' . "\r\n" . '<html lang="en">' . "\r\n\r\n" . '<head>' . "\r\n\r\n" . '    ';
include 'assets/includes/title-meta.php';
echo "\r\n" . '    ';
include 'assets/includes/head-css.php';
echo "\r\n" . '</head>' . "\r\n\r\n" . '<body data-sidebar="dark">' . "\r\n\r\n" . '    <!-- Loader -->' . "\r\n" . '    <div id="preloader">' . "\r\n" . '        <div id="status">' . "\r\n" . '            <div class="spinner">' . "\r\n" . '                <i class="ri-loader-line spin-icon"></i>' . "\r\n" . '            </div>' . "\r\n" . '        </div>' . "\r\n" . '    </div>' . "\r\n\r\n" . '    <div id="layout-wrapper">' . "\r\n\r\n" . '        ';
include 'assets/includes/topbar.php';
echo "\r\n" . '        ';
include 'assets/includes/sidebar.php';
echo "\r\n" . '        <div class="main-content">' . "\r\n\r\n" . '            <div class="page-content">' . "\r\n" . '                <div class="container-fluid">' . "\r\n\r\n" . '                    <div class="row">' . "\r\n" . '                        <div class="col-12">' . "\r\n" . '                            <div class="page-title-box d-flex align-items-center justify-content-between">' . "\r\n" . '                                <h4 class="mb-0">OTTRun VPN</h4>' . "\r\n\r\n" . '                                <div class="page-title-right">' . "\r\n" . '                                    <ol class="breadcrumb m-0">' . "\r\n" . '                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Applications</a></li>' . "\r\n" . '                                        <li class="breadcrumb-item"><a href="javascript: void(0);">OTTRun VPN</a></li>' . "\r\n" . '                                        <li class="breadcrumb-item active">OpenVPN Config</li>' . "\r\n" . '                                    </ol>' . "\r\n" . '                                </div>' . "\r\n\r\n" . '                            </div>' . "\r\n" . '                        </div>' . "\r\n" . '                    </div>' . "\r\n\r\n" . '                    <div class="row">' . "\r\n" . '                        <div class="col-12">' . "\r\n" . '                            <div class="card">' . "\r\n" . '                                <div class="card-body">' . "\r\n\r\n" . '                                    <h4 class="card-title">OpenVPN List</h4>' . "\r\n" . '                                    <p class="card-title-desc col-12">' . "\r\n" . '                                        <a data-toggle="modal" data-target="#credentials-modal" class="credentials-button btn-sm btn-secondary"><i class="dripicons-lock-open"></i> Edit Credentials</a> Please ensure to keep your credentials up-to-date.' . "\r\n" . '                                        <a data-toggle="modal" data-target="#add-modal" class="add-button btn-sm btn-secondary float-right"><i class="dripicons-document-new"></i> Add New Config</a>' . "\r\n" . '                                    </p>' . "\r\n\r\n" . '                                    <form method="POST">' . "\r\n" . '                                        <div class=row>' . "\r\n" . '                                            <div class="form-group mt-4 col-6">' . "\r\n" . '                                                <label for="group_by">Order-by</label>' . "\r\n" . '                                                <select class="custom-select" id="group-by" name="group-by">' . "\r\n" . '                                                    <option selected="id">id</option>' . "\r\n" . '                                                    <option value="vpn_country">vpn_country</option>' . "\r\n" . '                                                    <option value="vpn_location">vpn_location</option>' . "\r\n" . '                                                </select>' . "\r\n" . '                                            </div>' . "\r\n" . '                                            <div class="form-group mt-4 col-6">' . "\r\n" . '                                                <label for="order">Order</label>' . "\r\n" . '                                                <select class="custom-select" id="order" name="order">' . "\r\n" . '                                                    <option selected="ASC">ASC</option>' . "\r\n" . '                                                    <option value="DESC">DESC</option>' . "\r\n" . '                                                </select>' . "\r\n" . '                                            </div>' . "\r\n" . '                                        </div>' . "\r\n" . '                                        <div class="text-center mt-4">' . "\r\n" . '                                            <button type="submit" name="update-sorting" class="btn-sm btn-primary">Update Sorting Method</button>' . "\r\n" . '                                            <br />Please note you may need to clear application cache to see changes.' . "\r\n" . '                                        </div>' . "\r\n" . '                                    </form>' . "\r\n\r\n" . '                                    <br />' . "\r\n" . '                                    <div class="table-responsive">' . "\r\n" . '                                        <table id="datatable-buttons" class="table dt-responsive table-striped table-bordered nowrap" style="border-collapse: collapse; border-spacing: 0; width: 100%;">' . "\r\n" . '                                            <thead>' . "\r\n" . '                                                <tr>' . "\r\n" . '                                                    <th>ID</th>' . "\r\n" . '                                                    <th>Country</th>' . "\r\n" . '                                                    <th>Location</th>' . "\r\n" . '                                                    <th>Status</th>' . "\r\n" . '                                                    <th>URL</th>' . "\r\n" . '                                                    <th>Type</th>' . "\r\n" . '                                                    <th hidden>Auth Type</th>' . "\r\n" . '                                                    <th hidden>Auth Embedded</th>' . "\r\n" . '                                                    <th></th>' . "\r\n" . '                                                </tr>' . "\r\n" . '                                            </thead>' . "\r\n" . '                                            <tbody>' . "\r\n" . '                                                ';

while ($row = $ovpn_config->fetchArray()) {
	echo "\r\n" . '                                                    <tr>' . "\r\n" . '                                                        <td>';
	echo $row['id'];
	echo '</td>' . "\r\n" . '                                                        <td><img src="https://flagcdn.com/40x30/';

	if ($row['vpn_country'] == 'UK') {
		echo 'gb';
	}
	else {
		echo strtolower($row['vpn_country']);
	}

	echo '.png">' . "\r\n" . '                                                            <span id="country-code">';
	echo $row['vpn_country'];
	echo '</span>' . "\r\n" . '                                                        </td>' . "\r\n" . '                                                        <td>';
	echo $row['vpn_location'];
	echo '</td>' . "\r\n" . '                                                        <td>' . "\r\n" . '                                                            <div class="badge badge-soft-';

	if ($row['vpn_status'] == 'INACTIVE') {
		echo 'danger';
	}
	else {
		echo 'success';
	}

	echo ' font-size-12">' . "\r\n" . '                                                                <span id="vpn-status">';
	echo $row['vpn_status'];
	echo '</span>' . "\r\n" . '                                                            </div>' . "\r\n" . '                                                        </td>' . "\r\n" . '                                                        <td>';
	echo $row['vpn_config'];
	echo '</td>' . "\r\n" . '                                                        <td>';
	echo $row['vpn_type'];
	echo '</td>' . "\r\n" . '                                                        <td hidden><span id="vpn-auth-type">';
	echo $row['auth_type'];
	echo '</span></td>' . "\r\n" . '                                                        <td hidden><span id="vpn-auth-embedded">';
	echo $row['auth_embedded'];
	echo '</span></td>' . "\r\n" . '                                                        <td>' . "\r\n" . '                                                            <button type="button" data-toggle="modal" data-target="#edit-modal" class="edit-button btn-sm btn-primary waves-effect waves-light"><i class="dripicons-document-edit"></i></button>' . "\r\n" . '                                                            <button type="button" data-toggle="modal" data-target="#delete-modal" class="delete-button btn-sm btn-danger waves-effect waves-light"><i class="dripicons-trash"></i></button>' . "\r\n" . '                                                            ';

	if ($row['vpn_status'] == 'INACTIVE') {
		echo '                                                                <button onclick="window.location.href=\'./ottrunvpn_ovpn.php?enable_config=';
		echo $row['id'];
		echo '\'" class="enable-button btn-sm btn-success waves-effect waves-light"><i class="dripicons-checkmark"></i></button>' . "\r\n" . '                                                            ';
	}
	else {
		echo '                                                                <button onclick="window.location.href=\'./ottrunvpn_ovpn.php?disable_config=';
		echo $row['id'];
		echo '\'" class="disable-button btn-sm btn-danger waves-effect waves-light"><i class="dripicons-cross"></i></button>' . "\r\n" . '                                                            ';
	}

	echo '                                                        </td>' . "\r\n" . '                                                    </tr>' . "\r\n\r\n" . '                                                ';
}

echo '                                            </tbody>' . "\r\n" . '                                        </table>' . "\r\n" . '                                    </div>' . "\r\n\r\n" . '                                    <div class="modal fade" id="add-modal" tabindex="-1" role="dialog" aria-labelledby="addModalLabel" aria-hidden="true">' . "\r\n" . '                                        <div class="modal-dialog modal-dialog-centered" role="document">' . "\r\n" . '                                            <div class="modal-content">' . "\r\n" . '                                                <div class="modal-header border-bottom-0">' . "\r\n" . '                                                    <h5 class="modal-title" id="addModalLabel">Add OVPN Config</h5>' . "\r\n" . '                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">' . "\r\n" . '                                                        <span class="text-danger" aria-hidden="true">&times;</span>' . "\r\n" . '                                                    </button>' . "\r\n" . '                                                </div>' . "\r\n" . '                                                <form method="POST">' . "\r\n" . '                                                    <div class="modal-body">' . "\r\n" . '                                                        <div class="form-group">' . "\r\n" . '                                                            <label for="add-country">Country</label>' . "\r\n" . '                                                            <select class="custom-select" id="add-country" name="add-country">' . "\r\n" . '                                                                ';
include 'assets/includes/select-country.php';
echo '                                                            </select>' . "\r\n" . '                                                            <small id="add-country-small" class="form-text text-muted"><em>Country of config.</em></small>' . "\r\n" . '                                                        </div>' . "\r\n" . '                                                        <div class="form-group">' . "\r\n" . '                                                            <label for="add-location">Location</label>' . "\r\n" . '                                                            <input type="text" class="form-control" id="add-location" name="add-location" placeholder="Enter location">' . "\r\n" . '                                                            <small id="add-location-small" class="form-text text-muted"><em>Location of config.</em></small>' . "\r\n" . '                                                        </div>' . "\r\n" . '                                                        <div class="form-group">' . "\r\n" . '                                                            <label for="add-url">URL</label>' . "\r\n" . '                                                            <input type="text" class="form-control" id="add-url" name="add-url" placeholder="Enter url">' . "\r\n" . '                                                            <small id="add-url-small" class="form-text text-muted"><em>URL of config.</em></small>' . "\r\n" . '                                                        </div>' . "\r\n" . '                                                        <div class="form-group">' . "\r\n" . '                                                            <label for="add-status">Status</label>' . "\r\n" . '                                                            <select class="custom-select" id="add-status" name="add-status">' . "\r\n" . '                                                                <option selected="ACTIVE">ACTIVE</option>' . "\r\n" . '                                                                <option value="INACTIVE">INACTIVE</option>' . "\r\n" . '                                                            </select>' . "\r\n" . '                                                            <small id="add-status-small" class="form-text text-muted"><em>Status of config.</em></small>' . "\r\n" . '                                                        </div>' . "\r\n" . '                                                        <div class="form-group">' . "\r\n" . '                                                            <label for="add-type">Service</label>' . "\r\n" . '                                                            <select class="custom-select" id="add-type" name="add-type">' . "\r\n" . '                                                                <option selected="Surfshark">Surfshark</option>' . "\r\n" . '                                                                <option value="IPVanish">IPVanish</option>' . "\r\n" . '                                                                <option value="NordVPN">NordVPN</option>' . "\r\n" . '                                                                <option value="OpenVPN">OpenVPN</option>' . "\r\n" . '                                                            </select>' . "\r\n" . '                                                            <small id="add-type-small" class="form-text text-muted"><em>Service of config.</em></small>' . "\r\n" . '                                                        </div>' . "\r\n" . '                                                        <div class="form-group">' . "\r\n" . '                                                            <label for="add-auth-type">Auth Type</label>' . "\r\n" . '                                                            <select class="custom-select" id="add-auth-type" name="add-auth-type">' . "\r\n" . '                                                                <option selected="up">up</option>' . "\r\n" . '                                                                <option value="noup">noup</option>' . "\r\n" . '                                                            </select>' . "\r\n" . '                                                            <small id="add-auth-type-small" class="form-text text-muted"><em>Auth type of config. (up - user&pass / noup - no user&pass)</em></small>' . "\r\n" . '                                                        </div>' . "\r\n" . '                                                        <div class="form-group">' . "\r\n" . '                                                            <label for="add-auth-embedded">Auth Embedded</label>' . "\r\n" . '                                                            <select class="custom-select" id="add-auth-embedded" name="add-auth-embedded">' . "\r\n" . '                                                                <option selected="NO">NO</option>' . "\r\n" . '                                                                <option value="YES">YES</option>' . "\r\n" . '                                                            </select>' . "\r\n" . '                                                            <small id="add-auth-embedded-small" class="form-text text-muted"><em>Auth embedded in conf?</em></small>' . "\r\n" . '                                                        </div>' . "\r\n" . '                                                    </div>' . "\r\n" . '                                                    <div class="modal-footer text-center mt-4">' . "\r\n" . '                                                        <button type="submit" name="add_config" class="btn-sm btn-primary">Submit</button>' . "\r\n" . '                                                    </div>' . "\r\n" . '                                                </form>' . "\r\n" . '                                            </div>' . "\r\n" . '                                        </div>' . "\r\n" . '                                    </div>' . "\r\n\r\n" . '                                    <div class="modal fade" id="edit-modal" tabindex="-1" role="dialog" aria-labelledby="editModalLabel" aria-hidden="true">' . "\r\n" . '                                        <div class="modal-dialog modal-dialog-centered" role="document">' . "\r\n" . '                                            <div class="modal-content">' . "\r\n" . '                                                <div class="modal-header border-bottom-0">' . "\r\n" . '                                                    <h5 class="modal-title" id="editModalLabel">Edit OVPN Config</h5>' . "\r\n" . '                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">' . "\r\n" . '                                                        <span class="text-danger" aria-hidden="true">&times;</span>' . "\r\n" . '                                                    </button>' . "\r\n" . '                                                </div>' . "\r\n" . '                                                <form method="POST">' . "\r\n" . '                                                    <div class="modal-body">' . "\r\n" . '                                                        <div class="input-group row" hidden>' . "\r\n" . '                                                            <input type="text" class="form-control" id="edit-id" name="edit-id">' . "\r\n" . '                                                        </div>' . "\r\n" . '                                                        <div class="form-group">' . "\r\n" . '                                                            <label for="edit-country">Country</label>' . "\r\n" . '                                                            <select class="custom-select" id="edit-country" name="edit-country">' . "\r\n" . '                                                                ';
include 'assets/includes/select-country.php';
echo '                                                            </select>' . "\r\n" . '                                                            <small id="country-select-small" class="form-text text-muted"><em>Country of config.</em></small>' . "\r\n" . '                                                        </div>' . "\r\n" . '                                                        <div class="form-group">' . "\r\n" . '                                                            <label for="edit-location">Location</label>' . "\r\n" . '                                                            <input type="text" class="form-control" id="edit-location" name="edit-location" placeholder="Enter location">' . "\r\n" . '                                                            <small id="edit-location-small" class="form-text text-muted"><em>Location of config.</em></small>' . "\r\n" . '                                                        </div>' . "\r\n" . '                                                        <div class="form-group">' . "\r\n" . '                                                            <label for="edit-url">URL</label>' . "\r\n" . '                                                            <input type="text" class="form-control" id="edit-url" name="edit-url" placeholder="Enter url">' . "\r\n" . '                                                            <small id="edit-url-small" class="form-text text-muted"><em>URL of config.</em></small>' . "\r\n" . '                                                        </div>' . "\r\n" . '                                                        <div class="form-group">' . "\r\n" . '                                                            <label for="edit-status">Status</label>' . "\r\n" . '                                                            <select class="custom-select" id="edit-status" name="edit-status">' . "\r\n" . '                                                                <option selected="ACTIVE">ACTIVE</option>' . "\r\n" . '                                                                <option value="INACTIVE">INACTIVE</option>' . "\r\n" . '                                                            </select>' . "\r\n" . '                                                            <small id="edit-status-small" class="form-text text-muted"><em>Status of config.</em></small>' . "\r\n" . '                                                        </div>' . "\r\n" . '                                                        <div class="form-group">' . "\r\n" . '                                                            <label for="edit-type">Service</label>' . "\r\n" . '                                                            <select class="custom-select" id="edit-type" name="edit-type">' . "\r\n" . '                                                                <option selected="Surfshark">Surfshark</option>' . "\r\n" . '                                                                <option value="IPVanish">IPVanish</option>' . "\r\n" . '                                                                <option value="NordVPN">NordVPN</option>' . "\r\n" . '                                                                <option value="OpenVPN">OpenVPN</option>' . "\r\n" . '                                                            </select>' . "\r\n" . '                                                            <small id="edit-type-small" class="form-text text-muted"><em>Service of config.</em></small>' . "\r\n" . '                                                        </div>' . "\r\n" . '                                                        <div class="form-group">' . "\r\n" . '                                                            <label for="edit-auth-type">Auth Type</label>' . "\r\n" . '                                                            <select class="custom-select" id="edit-auth-type" name="edit-auth-type">' . "\r\n" . '                                                                <option selected="up">up</option>' . "\r\n" . '                                                                <option value="noup">noup</option>' . "\r\n" . '                                                            </select>' . "\r\n" . '                                                            <small id="edit-auth-type-small" class="form-text text-muted"><em>Auth type of config. (up - user&pass / noup - no user&pass)</em></small>' . "\r\n" . '                                                        </div>' . "\r\n" . '                                                        <div class="form-group">' . "\r\n" . '                                                            <label for="edit-auth-embedded">Auth Embedded</label>' . "\r\n" . '                                                            <select class="custom-select" id="edit-auth-embedded" name="edit-auth-embedded">' . "\r\n" . '                                                                <option selected="NO">NO</option>' . "\r\n" . '                                                                <option value="YES">YES</option>' . "\r\n" . '                                                            </select>' . "\r\n" . '                                                            <small id="edit-auth-embedded-small" class="form-text text-muted"><em>Auth embedded in conf?</em></small>' . "\r\n" . '                                                        </div>' . "\r\n" . '                                                    </div>' . "\r\n" . '                                                    <div class="modal-footer text-center mt-4">' . "\r\n" . '                                                        <button type="submit" name="edit_config" class="btn-sm btn-primary">Save</button>' . "\r\n" . '                                                    </div>' . "\r\n" . '                                                </form>' . "\r\n" . '                                            </div>' . "\r\n" . '                                        </div>' . "\r\n" . '                                    </div>' . "\r\n\r\n" . '                                    <div class="modal fade" id="delete-modal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel" aria-hidden="true">' . "\r\n" . '                                        <div class="modal-dialog modal-dialog-centered" role="document">' . "\r\n" . '                                            <div class="modal-content">' . "\r\n" . '                                                <div class="modal-header border-bottom-0">' . "\r\n" . '                                                    <h5 class="modal-title" id="deleteModalLabel">Delete OVPN Config</h5>' . "\r\n" . '                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">' . "\r\n" . '                                                        <span class="text-danger" aria-hidden="true">&times;</span>' . "\r\n" . '                                                    </button>' . "\r\n" . '                                                </div>' . "\r\n" . '                                                <form method="POST">' . "\r\n" . '                                                    <div class="modal-body">' . "\r\n" . '                                                        <div class="form-group" hidden>' . "\r\n" . '                                                            <input type="text" class="form-control" id="delete-id" name="delete-id">' . "\r\n" . '                                                        </div>' . "\r\n" . '                                                        <h3 class="text-center mt-4">Are you sure?</h3>' . "\r\n" . '                                                    </div>' . "\r\n" . '                                                    <div class="modal-footer text-center mt-4">' . "\r\n" . '                                                        <button type="submit" name="delete_config" class="btn-sm btn-danger">Delete</button>' . "\r\n" . '                                                    </div>' . "\r\n" . '                                                </form>' . "\r\n" . '                                            </div>' . "\r\n" . '                                        </div>' . "\r\n" . '                                    </div>' . "\r\n\r\n" . '                                    <script>' . "\r\n" . '                                        $(function() {' . "\r\n" . '                                            $(".edit-button").on(\'click\', function() {' . "\r\n" . '                                                var currentRow = $(this).closest("tr");' . "\r\n" . '                                                var id = currentRow.find("td:eq(0)").text();' . "\r\n" . '                                                var country = currentRow.find("#country-code").text();' . "\r\n" . '                                                var location = currentRow.find("td:eq(2)").text();' . "\r\n" . '                                                var status = currentRow.find("#vpn-status").text();' . "\r\n" . '                                                var url = currentRow.find("td:eq(4)").text();' . "\r\n" . '                                                var type = currentRow.find("td:eq(5)").text();' . "\r\n" . '                                                var auth_type = currentRow.find("#vpn-auth-type").text();' . "\r\n" . '                                                var auth_embedded = currentRow.find("#vpn-auth-embedded").text();' . "\r\n" . '                                                $("#edit-id").val(id);' . "\r\n" . '                                                $("#edit-country:selected").prop("selected", false);' . "\r\n" . '                                                $("#edit-country option[value=" + country + "]").prop("selected", true);' . "\r\n" . '                                                $("#edit-location").val(location);' . "\r\n" . '                                                $("#edit-status").val(status);' . "\r\n" . '                                                $("#edit-url").val(url);' . "\r\n" . '                                                $("#edit-type").val(type);' . "\r\n" . '                                                $("#edit-auth-type").val(auth_type);' . "\r\n" . '                                                $("#edit-auth-embedded").val(auth_embedded);' . "\r\n" . '                                            });' . "\r\n" . '                                            $(".enable-button").on(\'click\', function() {' . "\r\n" . '                                                var currentRow = $(this).closest("tr");' . "\r\n" . '                                                var id = currentRow.find("td:eq(0)").text();' . "\r\n" . '                                                $("#enable-id").val(id);' . "\r\n" . '                                            });' . "\r\n" . '                                            $(".disable-button").on(\'click\', function() {' . "\r\n" . '                                                var currentRow = $(this).closest("tr");' . "\r\n" . '                                                var id = currentRow.find("td:eq(0)").text();' . "\r\n" . '                                                $("#disable-id").val(id);' . "\r\n" . '                                            });' . "\r\n" . '                                            $(".delete-button").on(\'click\', function() {' . "\r\n" . '                                                var currentRow = $(this).closest("tr");' . "\r\n" . '                                                var id = currentRow.find("td:eq(0)").text();' . "\r\n" . '                                                $("#delete-id").val(id);' . "\r\n" . '                                            });' . "\r\n" . '                                        });' . "\r\n" . '                                    </script>' . "\r\n\r\n" . '                                </div>' . "\r\n" . '                            </div>' . "\r\n" . '                        </div>' . "\r\n" . '                    </div>' . "\r\n" . '                    <div class="modal fade" id="credentials-modal" tabindex="-1" role="dialog" aria-labelledby="credentialsModalLabel" aria-hidden="true">' . "\r\n" . '                        <div class="modal-dialog modal-dialog-centered" role="document">' . "\r\n" . '                            <div class="modal-content">' . "\r\n" . '                                <div class="modal-header border-bottom-0">' . "\r\n" . '                                    <h5 class="modal-title" id="credentialsModalLabel">Edit Credentials</h5>' . "\r\n" . '                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">' . "\r\n" . '                                        <span class="text-danger" aria-hidden="true">&times;</span>' . "\r\n" . '                                    </button>' . "\r\n" . '                                </div>' . "\r\n" . '                                <div class="row">' . "\r\n" . '                                    <div class="col-12">' . "\r\n" . '                                        <div class="card">' . "\r\n" . '                                            <div class="card-body">' . "\r\n" . '                                                <h4 class="card-title">Credentials</h4>' . "\r\n" . '                                                <p class="card-title-desc">You will need to add the OpenVPN credentials for each' . "\r\n" . '                                                    account you use, for examlple if you use Surfshark OVPN configurations you will' . "\r\n" . '                                                    need to save your Surfshark OVPN credentials.</p>' . "\r\n\r\n" . '                                                <!-- Nav tabs -->' . "\r\n" . '                                                <ul class="nav nav-tabs nav-tabs-custom nav-justified" role="tablist">' . "\r\n" . '                                                    <li class="nav-item">' . "\r\n" . '                                                        <a class="nav-link active" data-toggle="tab" href="#custom-ovpn" role="tab">' . "\r\n" . '                                                            <span class="d-block d-sm-none"><i class="ri-shield-user-line"></i></span>' . "\r\n" . '                                                            <span class="d-none d-sm-block">OpenVPN</span>' . "\r\n" . '                                                        </a>' . "\r\n" . '                                                    </li>' . "\r\n" . '                                                    <li class="nav-item">' . "\r\n" . '                                                        <a class="nav-link" data-toggle="tab" href="#surfshark" role="tab">' . "\r\n" . '                                                            <span class="d-block d-sm-none"><i class="ri-shield-user-line"></i></span>' . "\r\n" . '                                                            <span class="d-none d-sm-block">Surfshark</span>' . "\r\n" . '                                                        </a>' . "\r\n" . '                                                    </li>' . "\r\n" . '                                                    <li class="nav-item">' . "\r\n" . '                                                        <a class="nav-link" data-toggle="tab" href="#ipvanish" role="tab">' . "\r\n" . '                                                            <span class="d-block d-sm-none"><i class="ri-shield-user-line"></i></span>' . "\r\n" . '                                                            <span class="d-none d-sm-block">IPVanish</span>' . "\r\n" . '                                                        </a>' . "\r\n" . '                                                    </li>' . "\r\n" . '                                                    <li class="nav-item">' . "\r\n" . '                                                        <a class="nav-link" data-toggle="tab" href="#nordvpn" role="tab">' . "\r\n" . '                                                            <span class="d-block d-sm-none"><i class="ri-shield-user-line"></i></span>' . "\r\n" . '                                                            <span class="d-none d-sm-block">NordVPN</span>' . "\r\n" . '                                                        </a>' . "\r\n" . '                                                    </li>' . "\r\n" . '                                                </ul>' . "\r\n\r\n" . '                                                <!-- Tab panes -->' . "\r\n\r\n" . '                                                <div class="tab-content p-3 text-muted">' . "\r\n" . '                                                    <div class="tab-pane active" id="custom-ovpn" role="tabpanel">' . "\r\n" . '                                                        <form method="POST">' . "\r\n" . '                                                            <div class="form-group-sm row mt-1">' . "\r\n" . '                                                                <label class="col-md-3 col-form-label" for="openvpn-user-name">Username</label>' . "\r\n" . '                                                                <div class="col-md-9">' . "\r\n" . '                                                                    <input type="text" id="openvpn-user-name" name="openvpn-user-name" class="form-control" placeholder="Enter openvpn username">' . "\r\n" . '                                                                </div>' . "\r\n" . '                                                            </div>' . "\r\n" . '                                                            <div class="form-group-sm row mt-1">' . "\r\n" . '                                                                <label class="col-md-3 col-form-label" for="openvpn-password">Password</label>' . "\r\n" . '                                                                <div class="col-md-9">' . "\r\n" . '                                                                    <input type="password" id="openvpn-password" name="openvpn-password" class="form-control" placeholder="Enter openvpn password">' . "\r\n" . '                                                                </div>' . "\r\n" . '                                                            </div>' . "\r\n" . '                                                            <div class="text-center mt-1">' . "\r\n" . '                                                                <button type="submit" name="save_ovpn_credentials" class="btn-sm btn-primary waves-effect waves-light">Update</button>' . "\r\n" . '                                                            </div>' . "\r\n" . '                                                        </form>' . "\r\n" . '                                                    </div>' . "\r\n" . '                                                    <div class="tab-pane" id="surfshark" role="tabpanel">' . "\r\n" . '                                                        <form method="POST">' . "\r\n" . '                                                            <div class="form-group-sm row mt-1">' . "\r\n" . '                                                                <label class="col-md-3 col-form-label" for="surfshark-username">Username</label>' . "\r\n" . '                                                                <div class="col-md-9">' . "\r\n" . '                                                                    <input type="text" id="surfshark-username" name="surfshark-username" class="form-control" placeholder="Enter surfshark username">' . "\r\n" . '                                                                </div>' . "\r\n" . '                                                            </div>' . "\r\n" . '                                                            <div class="form-group-sm row mt-1">' . "\r\n" . '                                                                <label class="col-md-3 col-form-label" for="surfshark-password">Password</label>' . "\r\n" . '                                                                <div class="col-md-9">' . "\r\n" . '                                                                    <input type="password" id="surfshark-password" name="surfshark-password" class="form-control" placeholder="Enter surfshark password">' . "\r\n" . '                                                                </div>' . "\r\n" . '                                                            </div>' . "\r\n" . '                                                            More info <a href="https://my.surfshark.com/vpn/manual-setup/router/openvpn">here</a>' . "\r\n" . '                                                            <div class="text-center mt-1">' . "\r\n" . '                                                                <button type="submit" name="save_surfshark_credentials" class="btn-sm btn-primary waves-effect waves-light">Update</button>' . "\r\n" . '                                                            </div>' . "\r\n" . '                                                        </form>' . "\r\n" . '                                                    </div>' . "\r\n" . '                                                    <div class="tab-pane" id="ipvanish" role="tabpanel">' . "\r\n" . '                                                        <form method="POST">' . "\r\n" . '                                                            <div class="form-group-sm row mt-1">' . "\r\n" . '                                                                <label class="col-md-3 col-form-label" for="ipvanish-username">Username</label>' . "\r\n" . '                                                                <div class="col-md-9">' . "\r\n" . '                                                                    <input type="text" id="ipvanish-username" name="ipvanish-username" class="form-control" placeholder="Enter ipvanish username">' . "\r\n" . '                                                                </div>' . "\r\n" . '                                                            </div>' . "\r\n" . '                                                            <div class="form-group-sm row mt-1">' . "\r\n" . '                                                                <label class="col-md-3 col-form-label" for="ipvanish-password">Password</label>' . "\r\n" . '                                                                <div class="col-md-9">' . "\r\n" . '                                                                    <input type="password" id="ipvanish-password" name="ipvanish-password" class="form-control" placeholder="Enter ipvanish password">' . "\r\n" . '                                                                </div>' . "\r\n" . '                                                            </div>' . "\r\n" . '                                                            More info <a href="https://configs.ipvanish.com/configs/">here</a>' . "\r\n" . '                                                            <div class="text-center mt-1">' . "\r\n" . '                                                                <button type="submit" name="save_ipvanish_credentials" class="btn-sm btn-primary waves-effect waves-light">Update</button>' . "\r\n" . '                                                            </div>' . "\r\n" . '                                                        </form>' . "\r\n" . '                                                    </div>' . "\r\n" . '                                                    <div class="tab-pane" id="nordvpn" role="tabpanel">' . "\r\n" . '                                                        <form method="POST">' . "\r\n" . '                                                            <div class="form-group-sm row mt-1">' . "\r\n" . '                                                                <label class="col-md-3 col-form-label" for="nordvpn-username">Username</label>' . "\r\n" . '                                                                <div class="col-md-9">' . "\r\n" . '                                                                    <input type="text" id="nordvpn-username" name="nordvpn-username" class="form-control" placeholder="Enter nordvpn username">' . "\r\n" . '                                                                </div>' . "\r\n" . '                                                            </div>' . "\r\n" . '                                                            <div class="form-group-sm row mt-1">' . "\r\n" . '                                                                <label class="col-md-3 col-form-label" for="nordvpn-password">Password</label>' . "\r\n" . '                                                                <div class="col-md-9">' . "\r\n" . '                                                                    <input type="password" id="nordvpn-password" name="nordvpn-password" class="form-control" placeholder="Enter nordvpn password">' . "\r\n" . '                                                                </div>' . "\r\n" . '                                                            </div>' . "\r\n" . '                                                            More info <a href="https://nordvpn.com/servers/tools/">here</a>' . "\r\n" . '                                                            <div class="text-center mt-1">' . "\r\n" . '                                                                <button type="submit" name="save_nordvpn_credentials" class="btn-sm btn-primary waves-effect waves-light">Update</button>' . "\r\n" . '                                                            </div>' . "\r\n" . '                                                        </form>' . "\r\n" . '                                                    </div>' . "\r\n" . '                                                </div>' . "\r\n" . '                                            </div>' . "\r\n" . '                                        </div>' . "\r\n" . '                                    </div>' . "\r\n" . '                                </div>' . "\r\n" . '                            </div>' . "\r\n" . '                        </div> <!-- end col -->' . "\r\n" . '                    </div> <!-- end row -->' . "\r\n\r\n" . '                </div>' . "\r\n" . '            </div>' . "\r\n\r\n" . '            ';
include 'assets/includes/footer.php';
echo '        </div>' . "\r\n\r\n" . '    </div>' . "\r\n\r\n" . '    ';
include 'assets/includes/right-sidebar.php';
echo "\r\n" . '    ';
include 'assets/includes/vendor-scripts.php';
echo "\r\n" . '    <script src="./assets/js/app.js"></script>' . "\r\n\r\n" . '</body>' . "\r\n\r\n" . '</html>';

?>